<?php

namespace AGrS\Models;

use Illuminate\Database\Eloquent\Model;

class Section extends Model 
{

    protected $table = 'sections';
    public $timestamps = false;

    public function name()
    {
        return $this->hasOne('AGrS\Models\SectionName');
    }

    public function adviser()
    {
        return $this->hasOne('AGrS\Models\Teacher');
    }

    public function subjects()
    {
        return $this->belongsToMany('AGrS\Models\Subject');
    }

    public function learners()
    {
        return $this->belongsToMany('AGrS\Models\Learner');
    }

}